function [words2, MFs, Cs]=getFOUsC8()

%
% [words, MFs, Cs, Cls, Crs]=getFOUsC8()
%
% To compute the 9 word FOUs in Chapter 8 from interval survey data (datacopy.xls)
% using the Interval Approach.
%
% Dongrui Wu (dongruiw@usc.edu), 4/19/2009
%
% words2: names of the 9 words
% MFs: MFs of the 9 words, each described by 9 parameters (see Fig. 1 in
% Readme.doc)
% Cs: centers of centroids of the 9 words


%% Read Data
A = xlsread('datacopy.xls');
[row, col] = size(A);

%% Names of the 32 words
MFs=zeros(col/2,9);
words=[
    '          Little          ';
    '         Sizeable         ';
    '        Large (LA)        ';
    '     Quite A Bit (QAB)    ';
    '         Low Amount       ';
    '     Somewhat Small (SS)  ';
    '        A Smidgen         ';
    'None to Very Little (NVL) ';
    '     Humongous Amount     ';
    '        Huge Amount       ';
    '        Very Small        ';
    '        Very Large        ';
    '        Fair Amount       ';
    '    Modest Amount (MOA)   ';
    '       Very Little        ';
    '   Moderate Amount (MRA)  ';
    '           Medium         ';
    '     Good Amount (GA)     ';
    '      Extreme Amount      ';
    '       Teeny-Weeny        ';
    ' Considerable Amount (CA) ';
    '         A Lot (AL)       ';
    '         A Bit (AB)       ';
    '      Very Sizeable       ';
    '     Some to Moderate     ';
    '        High Amount       ';
    '           Small          ';
    '   Maximum Amount (MAA)   ';
    '         Some (S)         ';
    '          Tiny            ';
    '     Very High Amount     ';
    '    Substantial Amount    '];

%%  Compute the FOUs and centroids
for i=1:col/2
    L = A(1:row, 2*i-1);  %% Left end-points for interval data.
    R = A(1:row, 2*i);    %% Right end-points for interval data.
    MFs(i,:) = IA(L,R); %% Map into an IT2 FS
    Cs(i)=centroidIT2(MFs(i,:)); %% Compute the centroid
end

%% Sort the MFs in ascending order according to the centers of centroids
[Cs,index]=sort(Cs);  % Sort the centers of the centroids
MFs=MFs(index,:);     % Reorder the MFs
words=words(index,:); % Reorder the names of words

%% use only 9 of the 32 words
subset=[1 7 10 12 14 18 21 26 32];
words=words(subset,:);
MFs=MFs(subset,:);
Cs=Cs(subset);

for i=1:length(subset)
    position=find(words(i,1:floor(size(words,2)/2))~=' ',1,'first');
    if i<10
        words2(i,1:size(words,2)+4)=[words(i,1:position-1) num2str(i) '.  ' words(i,position:end)];
    else
        words2(i,1:size(words,2)+4)=[words(i,1:position-1) num2str(i) '. ' words(i,position:end)];
    end
end